/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.pa.admin.IPAAdministration;
import filenet.pa.admin.PAAdministration;
import filenet.pa.admin.PAStatisticsSnapShot;
import filenet.pa.sql.ExposedField;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskProcessLauncher;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.pa.PAActionCommand;
import filenet.vw.apps.taskman.pa.PADataFieldsNode;
import filenet.vw.apps.taskman.pa.PAPropertyPanel;
import filenet.vw.apps.taskman.pa.PAPruneRegionDialog;
import filenet.vw.apps.taskman.pa.PAUpgradeDatabaseDialog;
import filenet.vw.apps.taskman.pa.images.VWImageLoader;
import filenet.vw.apps.taskman.pa.monitor.PAMonitorNode;
import filenet.vw.apps.taskman.pa.panonrmi.IPANonRMI;
import filenet.vw.apps.taskman.pa.panonrmi.PANonRMIFactory;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PANode
extends VWTaskBaseNode {
    private PAPropertyPanel m_propertyPanel = null;
    private IPAAdministration m_pa = null;
    private PADataFieldsNode m_dataFieldsNode = null;
    private PAMonitorNode m_monitorNode = null;
    private Properties m_properties = null;
    private int m_paCurrentJob = -1;
    private String m_propertiesPath = null;
    private String m_installDirectory = null;
    private boolean m_isService = false;
    private int m_paMode = -1;
    public static final String XML_NODE_NAME = "CaseAnalyzer";
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("pa_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("pa_16.gif");
    protected static final ImageIcon nodeIconS32 = VWImageLoader.createImageIcon("pa_stop_32.gif");
    protected static final ImageIcon nodeIconS16 = VWImageLoader.createImageIcon("pa_stop_16.gif");

    public PANode(String propertiesPath) throws Exception {
        super(VWResource.CaseAnalyzer, propertiesPath, "TaskManager.CaseAnalyzer", 22);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.setExpandAtStartup(true);
        this.fromXML();
        this.initializePaths();
        this.setPAProperties(this.readPropertyFile());
        this.m_paMode = 101;
        try {
            this.m_paMode = Integer.parseInt(this.m_properties.getProperty("analyzer.mode"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new PAPropertyPanel(this);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel, true, true);
            this.m_dataFieldsNode = new PADataFieldsNode(this);
            this.add(this.m_dataFieldsNode);
            this.m_monitorNode = new PAMonitorNode(this);
            this.add(this.m_monitorNode);
        }
    }

    public void refresh() {
        try {
            this.refreshPAConnection();
            if (!VWTaskCore.getInstance().isAutoMode()) {
                this.m_propertyPanel.refresh();
                if (!this.isDirty()) {
                    this.m_propertyPanel.resetProperties();
                }
                super.refreshChildren();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public void start() throws Exception {
        this.start(false, false);
    }

    private void start(boolean bUpgradePA, boolean bStopPAAfterUpgrade) throws Exception {
        block21: {
            try {
                VWTaskProcessResult result;
                this.refreshPAConnection();
                if (this.isStarted()) {
                    return;
                }
                if (!VWTaskCore.getInstance().isAutoMode() && !this.m_propertyPanel.validateProperties()) {
                    return;
                }
                if (!bUpgradePA && !VWTaskCore.getInstance().isAutoMode()) {
                    this.writeMessage(Level.INFO, VWResource.StartingProcessAnalyzer);
                }
                StringBuffer command = new StringBuffer("filenet.pa.main.Main -tm");
                if (bUpgradePA) {
                    command.append(" -upgrade");
                    if (!bStopPAAfterUpgrade) {
                        command.append(" -start");
                    }
                }
                ArrayList<String> javaArgs = new ArrayList<String>();
                StringBuffer cp = new StringBuffer(System.getProperty("java.class.path"));
                String paClassPath = this.getProperty("TaskManager.CaseAnalyzer.ClassPath", null);
                if (paClassPath != null) {
                    cp.append(File.pathSeparator);
                    cp.append(paClassPath);
                }
                cp.append(File.pathSeparator);
                cp.append(this.m_properties.getProperty("analyzer.db.jdbcdriver.classpath", ""));
                cp.append(File.pathSeparator);
                cp.append(this.m_properties.getProperty("analyzer.pedb.jdbcdriver.classpath", ""));
                if (cp.length() > 0) {
                    javaArgs.add("-cp");
                    javaArgs.add(cp.toString());
                }
                javaArgs.add("\"-Danalyzer.properties=" + this.m_propertiesPath + "\"");
                javaArgs.add("\"-DPELogFile=" + VWTaskUtil.backSlashToForwardSlash(this.getLogPath()) + "\"");
                javaArgs.add("\"-DPELogLevel=" + this.getLogLevel().toString() + "\"");
                int javaMinMem = this.getJavaMinMemory();
                int javaMaxMem = this.getJavaMaxMemory();
                javaMinMem = javaMinMem != -1 && javaMinMem < 1 ? 1 : javaMinMem;
                int n = javaMaxMem = javaMaxMem != -1 && javaMaxMem < 2 ? 2 : javaMaxMem;
                if (javaMinMem != -1) {
                    javaArgs.add("-Xms" + javaMinMem + "m");
                }
                if (javaMaxMem != -1) {
                    javaArgs.add("-Xmx" + javaMaxMem + "m");
                }
                if ((result = VWTaskProcessLauncher.launchJavaServer(javaArgs, command.toString(), false, null, this)).getResult() != null) {
                    this.setPAAdministration((IPAAdministration)result.getResult());
                    if (!VWTaskCore.getInstance().isAutoMode()) {
                        this.m_propertyPanel.setStatus(VWResource.Running);
                    }
                    break block21;
                }
                if (bStopPAAfterUpgrade && result.exitValue() == 0) {
                    this.m_pa = null;
                    break block21;
                }
                if (result.exitValue() == 2) {
                    if (!VWTaskCore.getInstance().isAutoMode()) {
                        PAUpgradeDatabaseDialog dlg = PAUpgradeDatabaseDialog.getInstance();
                        dlg.show();
                        if (dlg.buttonSelected() == 1) {
                            this.start(true, dlg.stopPAAfterUpgrade());
                        }
                        return;
                    }
                    throw new VWException("filenet.vw.apps.taskman.pa.PANode.PADBNeedsToBeUpgraded", "The Case Analyzer database needs to be upgraded.  To initiate the upgrade start the Case Analyzer from the Process Task Manager application.");
                }
                if (result.exitValue() == 3) {
                    throw new VWException("filenet.vw.apps.taskman.pa.PANode.UnsupportedSchemaVersion", "The Case Analyzer does not recognize the schema version.  The software must be updated.");
                }
                if (result.getError().length() > 0) {
                    throw new Exception(result.getError());
                }
                throw new Exception(result.getOutput());
            }
            catch (Exception ex) {
                this.m_pa = null;
                throw ex;
            }
        }
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh();
            super.refreshChildren();
        }
        if (bUpgradePA && bStopPAAfterUpgrade) {
            Runnable runner = new Runnable(){

                public void run() {
                    while (PANode.this.isStarted()) {
                        PANode.this.refreshPAConnection();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    PANode.this.writeMessage(Level.INFO, VWResource.ProcessAnalyzerStopped);
                    PANode.this.nodeChanged();
                }
            };
            new Thread(runner).start();
        }
    }

    public void stop() throws Exception {
        this.refreshPAConnection();
        if (!this.isStarted()) {
            return;
        }
        this.writeMessage(Level.INFO, VWResource.StoppingProcessAnalyzer);
        this.setConsoleHandler(null);
        try {
            VWDebug.logInfo("Stopping Case Analyzer, calling IPAAdministration.unbind()...");
            this.m_pa.shutDown();
        }
        catch (UnmarshalException unmarshalException) {
            // empty catch block
        }
        VWDebug.logInfo("Proces Analyzer has been stopped.");
        this.writeMessage(Level.INFO, VWResource.ProcessAnalyzerStopped);
        this.m_pa = null;
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh();
            super.refreshChildren();
        }
    }

    public boolean isSimulationMode() {
        return this.m_paMode == 102;
    }

    public boolean isProductionMode() {
        return this.m_paMode == 101;
    }

    public boolean isMixedMode() {
        return this.m_paMode == 103;
    }

    public Properties getPAProperties() {
        return this.m_properties;
    }

    protected void setPAProperties(Properties props) {
        this.m_properties = props;
    }

    public String getPAPropertiesPath() {
        return this.m_propertiesPath;
    }

    public void updateStatistics(PAStatisticsSnapShot stats) {
        if (VWTaskCore.getInstance().isAutoMode()) {
            return;
        }
        int oldJob = this.m_paCurrentJob;
        if (stats != null) {
            this.m_paCurrentJob = stats.getCurrentJob();
            this.m_propertyPanel.updateStatistics(stats);
        } else {
            this.m_paCurrentJob = -1;
            this.m_propertyPanel.updateStatistics(null);
        }
        if (this.m_paCurrentJob != oldJob) {
            this.nodeChanged();
        }
    }

    public IPAAdministration getPAAdministration() {
        return this.m_pa;
    }

    public String getInstallDirectory() {
        return this.m_installDirectory;
    }

    public boolean isStarted() {
        return this.m_pa != null;
    }

    public Icon getIcon16() {
        if (this.isStarted()) {
            return nodeIcon16;
        }
        return nodeIconS16;
    }

    public Icon getIcon32() {
        if (this.isStarted()) {
            return nodeIcon32;
        }
        return nodeIconS32;
    }

    public String toString() {
        return this.getName();
    }

    public void displayHelp() {
        VWHelp.displayPage(this.getHelpPath("pa_prop.htm"));
    }

    protected String getContentEngineURL() {
        return this.m_propertyPanel.getContentEngineURL();
    }

    protected String getServiceUsername() {
        return this.m_propertyPanel.getServiceUsername();
    }

    protected String getServicePassword() {
        return this.m_propertyPanel.getServicePassword();
    }

    protected String getObjectStore() {
        return this.m_propertyPanel.getObjectStore();
    }

    private void refreshPAConnection() {
        this.setPAAdministration((IPAAdministration)this.lookupProcess());
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        theBuffer.append("\t<CaseAnalyzer ");
        theBuffer.append(this.getAutoStartAttributeString() + ">\n");
        this.m_dataFieldsNode.toXML(theBuffer);
        theBuffer.append("\t</CaseAnalyzer>\n");
    }

    private void fromXML() {
        try {
            Node node = this.getXMLNode();
            if (node == null) {
                return;
            }
            Element ele = (Element)node;
            this.setAutoStartEnabled(ele);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object lookupProcess() {
        IPAAdministration pa = null;
        Exception ex = null;
        try {
            int registryPort = this.getRegistryPort();
            String url = "rmi://localhost:" + Integer.toString(registryPort) + "/" + "FileNet.PA";
            pa = (IPAAdministration)Naming.lookup(url);
            pa.ping();
        }
        catch (NotBoundException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        catch (MalformedURLException e) {
            ex = e;
        }
        if (ex != null) {
            VWDebug.logInfo("VWPANode::lookupProcess() - " + ex.getLocalizedMessage());
            pa = null;
        }
        return pa;
    }

    public void writeMessage(Level logLevel, String message) {
        super.writeMessage(logLevel, message);
        if (message.equals(PAAdministration.STR_PRUNE_REGION_COMPLETED) && this.m_dataFieldsNode != null) {
            this.m_dataFieldsNode.refresh();
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, PAActionCommand.START) == 0) {
                this.start();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.STOP) == 0) {
                this.stop();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.ROLLUP_UTILITY) == 0) {
                this.launchRollupUtility();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.PROCESS_CUBES) == 0) {
                this.processCubes();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.PRUNE_EVENTS) == 0) {
                this.pruneEvents();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.STOP_PRUNE_EVENTS) == 0) {
                this.stopPruneEvents();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.PRUNE_ISOLATED_REGION) == 0) {
                this.pruneIsolatedRegion();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.REBUILD_OLAP) == 0) {
                this.rebuildOLAP();
            } else if (VWStringUtils.compare(actionCMD, PAActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add(PAActionCommand.START);
        actions.add(PAActionCommand.STOP);
        actions.add("Add Separator");
        actions.add(PAActionCommand.PROCESS_CUBES);
        if (this.m_paCurrentJob == 8) {
            actions.add(PAActionCommand.STOP_PRUNE_EVENTS);
        } else {
            actions.add(PAActionCommand.PRUNE_EVENTS);
        }
        actions.add(PAActionCommand.PRUNE_ISOLATED_REGION);
        actions.add("Add Separator");
        actions.add(PAActionCommand.ROLLUP_UTILITY);
        actions.add("Add Separator");
        actions.add(PAActionCommand.HELP);
        return actions.toArray(new String[0]);
    }

    public boolean isActionEnabled(String actionCMD) {
        if (VWStringUtils.compare(actionCMD, PAActionCommand.START) == 0) {
            return this.showStartIcon();
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.STOP) == 0) {
            return this.showStopIcon();
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.PROCESS_CUBES) == 0) {
            return this.isStarted() && this.m_paCurrentJob == 5;
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.PRUNE_EVENTS) == 0) {
            return this.isStarted() && this.m_paCurrentJob == 5;
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.PRUNE_ISOLATED_REGION) == 0) {
            return this.isStarted() && this.m_paCurrentJob == 5;
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.ROLLUP_UTILITY) == 0) {
            return !this.isStarted();
        }
        if (VWStringUtils.compare(actionCMD, PAActionCommand.REBUILD_OLAP) == 0) {
            return this.isStarted() && this.m_paCurrentJob == 5;
        }
        return true;
    }

    public boolean showStartIcon() {
        return !this.isStarted();
    }

    public boolean showStopIcon() {
        return this.isStarted() && !this.m_isService;
    }

    public boolean showDeleteIcon() {
        return false;
    }

    public boolean showPropertyIcon() {
        return true;
    }

    public boolean showCommitIcon() {
        return false;
    }

    public boolean showDiscardIcon() {
        return false;
    }

    public IPANonRMI getPANonRMI() throws Exception {
        return PANonRMIFactory.getInstance(this.m_properties.getProperty("analyzer.db.jdbcdriver.classpath") + File.pathSeparator + this.m_properties.getProperty("analyzer.pedb.jdbcdriver.classpath"));
    }

    public ExposedField[] getExposedDataFields() throws Exception {
        ExposedField[] fields = null;
        try {
            fields = this.getPANonRMI().getExposedDataFields();
        }
        catch (Exception ex) {
            VWString msg = new VWString("filenet.vw.apps.taskman.pa.PADataFieldsNode.getExposedDataFieldsException", "Unable to fetch data fields from the Case Analyzer database.");
            this.writeException(ex, msg.toString());
        }
        return fields;
    }

    protected void disposeDataField(String uniqueName) throws Exception {
        this.getPANonRMI().disposeDataField(uniqueName);
    }

    protected void updateDataField(String uniqueNameOrig, String uniqueNameMod, String fieldName, int cubes, int cubeOptions) throws Exception {
        this.getPANonRMI().updateDataField(uniqueNameOrig, uniqueNameMod, fieldName, cubes, cubeOptions);
    }

    protected void exposeDataField(String uniqueName, String fieldName, int nFieldType, boolean bMeasure, int cubes, int cubeOptions, Object[] ranges) throws Exception {
        this.getPANonRMI().exposeDataField(uniqueName, fieldName, nFieldType, bMeasure, cubes, cubeOptions, ranges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportDataFields(String fileName) throws Exception {
        String xml = this.getPANonRMI().exportUDF();
        if (xml != null) {
            Writer out = null;
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF8");
                out.write(xml);
                out.flush();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importDataFields(String fileName) throws Exception {
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        this.getPANonRMI().importUDF(buffer.toString());
    }

    protected void changeAdjustedMeasureSetting(boolean value) throws Exception {
        this.getPANonRMI().changeAdjustedMeasuresSetting(value);
    }

    private void setPAAdministration(IPAAdministration pa) {
        this.m_pa = pa;
        try {
            if (pa != null) {
                this.setConsoleHandler(pa.getConsoleHandler());
            } else {
                this.setConsoleHandler(null);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e, "Error while setting the console handler for Case Analyzer.");
        }
    }

    private void initializePaths() throws Exception {
        this.m_installDirectory = this.getProperty("TaskManager.CaseAnalyzer.Install");
        if (this.m_installDirectory != null) {
            if (!this.m_installDirectory.endsWith(File.separator)) {
                this.m_installDirectory = this.m_installDirectory + File.separator;
            }
        } else {
            throw new Exception("Invalid taskman.properties - PA install directory not specified.");
        }
        String haDirPath = this.getProperty("TaskManager.HASharedDirectory", null);
        this.m_propertiesPath = haDirPath != null ? haDirPath + File.separator + "analyzer.properties" : this.m_installDirectory + "analyzer.properties";
        System.setProperty("analyzer.properties", this.m_propertiesPath);
    }

    private void processCubes() throws Exception {
        if (this.displayConfirmation(VWResource.ProcessCubesConfirmation)) {
            this.m_pa.processCubes();
            this.writeMessage(Level.INFO, VWResource.ProcessCubesInitiated);
        }
    }

    private void pruneEvents() throws Exception {
        if (this.displayConfirmation(VWResource.PruneEventsConfirmation)) {
            this.m_pa.pruneEvents();
            this.writeMessage(Level.INFO, VWResource.PruneEventsInitiated);
        }
    }

    private void stopPruneEvents() throws Exception {
        this.m_pa.stopPruneEvents();
    }

    private void pruneIsolatedRegion() {
        PAPruneRegionDialog dlg = new PAPruneRegionDialog(this);
        dlg.setVisible(true);
    }

    private void rebuildOLAP() throws Exception {
    }

    private void launchRollupUtility() throws Exception {
        String dbHost = this.m_properties.getProperty("analyzer.db.server");
        try {
            if (!VWTaskUtil.isLocalHost(dbHost)) {
                VWString msg = new VWString("filenet.vw.apps.taskman.pa.PANode.RollupUtilityMustBeLaunchedonDBServer", "A remote database is being used, the compression wizard should be run on the remote database server.");
                VWTaskCore.getInstance().displayInformation(msg.toString());
                return;
            }
        }
        catch (UnknownHostException ex) {
            VWException vwEx = new VWException("filenet.vw.apps.taskman.pa.PANode.InvalidDatabasseHost", "The database host property is not valid.");
            vwEx.setCause(ex);
            throw vwEx;
        }
        String command = "filenet.pa.apps.rollup.RollupApplication";
        ArrayList<String> javaArgs = new ArrayList<String>();
        StringBuffer cp = new StringBuffer(System.getProperty("java.class.path"));
        String paClassPath = this.getProperty("TaskManager.CaseAnalyzer.ClassPath", null);
        if (paClassPath != null) {
            cp.append(File.pathSeparator);
            cp.append(paClassPath);
        }
        cp.append(File.pathSeparator);
        cp.append(this.m_properties.getProperty("analyzer.db.jdbcdriver.classpath", ""));
        if (cp.length() > 0) {
            javaArgs.add("-cp");
            javaArgs.add(cp.toString());
        }
        javaArgs.add("\"-Danalyzer.properties=" + this.m_propertiesPath + "\"");
        javaArgs.add("\"-DPELogFile=" + VWTaskUtil.backSlashToForwardSlash(this.getLogPath()) + "\"");
        javaArgs.add("\"-DPELogLevel=" + this.getLogLevel().toString() + "\"");
        javaArgs.add("\"-DWF_HELP=" + System.getProperty("WF_HELP") + "\"");
        int javaMinMem = this.getJavaMinMemory();
        int javaMaxMem = this.getJavaMaxMemory();
        javaMinMem = javaMinMem != -1 && javaMinMem < 1 ? 1 : javaMinMem;
        int n = javaMaxMem = javaMaxMem != -1 && javaMaxMem < 2 ? 2 : javaMaxMem;
        if (javaMinMem != -1) {
            javaArgs.add("-Xms" + javaMinMem + "m");
        }
        if (javaMaxMem != -1) {
            javaArgs.add("-Xmx" + javaMaxMem + "m");
        }
        VWTaskProcessResult result = VWTaskProcessLauncher.launchJavaProcess(javaArgs, command, true, false, false, false, this);
    }

    protected Node getXMLNode() {
        VWTaskXMLHandler xmlHandler = this.getXMLHandler();
        if (xmlHandler != null) {
            return VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), XML_NODE_NAME);
        }
        return null;
    }

    private int getJavaMinMemory() {
        int javaMinMemory = -1;
        try {
            javaMinMemory = Integer.parseInt(this.m_properties.getProperty("analyzer.javaMinMem", ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return javaMinMemory;
    }

    private int getJavaMaxMemory() {
        int javaMaxMemory = -1;
        try {
            javaMaxMemory = Integer.parseInt(this.m_properties.getProperty("analyzer.javaMaxMem", ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return javaMaxMemory;
    }

    private int getRegistryPort() {
        try {
            String strPort = this.m_properties.getProperty("analyzer.rmiPortNumber", "32771");
            return Integer.parseInt(strPort);
        }
        catch (NumberFormatException e) {
            return 32771;
        }
    }

    private String getLogPath() {
        String logPath = this.m_properties.getProperty("analyzer.logfile", null);
        if (logPath == null || logPath.equals("")) {
            logPath = this.getInstallDirectory() + "calog.txt";
        }
        return logPath;
    }

    private Level getLogLevel() {
        return Level.parse(this.m_properties.getProperty("analyzer.loglevel", Level.WARNING.toString()));
    }

    private Properties readPropertyFile() throws VWException {
        File propertiesFile = new File(this.m_propertiesPath);
        if (!propertiesFile.exists()) {
            throw new VWException("vw.apps.taskman.pa.PANode.CouldNotLocatePropertiesFile", "Could not locate properties file: {0}", this.m_propertiesPath);
        }
        FileInputStream propFile = null;
        try {
            propFile = new FileInputStream(this.m_propertiesPath);
            Properties properties = new Properties();
            properties.load(propFile);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            throw new VWException("vw.apps.taskman.pa.VWPAPropertyPanel.ErrorReadingPropsFile", "Error reading {0} properties file " + this.m_propertiesPath + " : {1}", VWResource.ProcessAnalyzer, e.getLocalizedMessage());
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                    propFile = null;
                }
                catch (Exception e) {}
            }
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   12 Dec 2008 09:54:20  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.52  $";
    }
}

